<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;

// Simple, so not use middleware
class AdminController extends Controller
{
    public function index(){
        $loginUser = Auth::user();
        if ($loginUser == null || $loginUser->role != 2)
            return redirect('/admin/auth');

        $users = User::where('id', '<>', $loginUser->id)->orderBy('role', 'desc')->get();
        return view('user_manager', compact('users'));
    }

    public function toogleActiveUser($id) {
        $user = User::find($id);
        if ($user == null)
            return;

        if ($user->active == 0) $user->active = 1;
        else if ($user->active == 1) $user->active = 0;

        $user->save();
        return redirect()->back();
    }
}
